function [x,w] = GLagTable(n)
% GLagTable  Nodes and weights for Gauss-Laguerre quadrature of order n<=15
%
% Synopsis:  [x,w] = GLagTable(n)
%
% Input:     n = number of nodes in quadrature rule, maximum: n = 25
%
% Output:    x = vector of nodes
%            w = vector of weights

% Numerical generated by makeGLagTable, and agree with those
% in "Handbook of Mathematical Functions", Abramowitz and Stegun, eds.,
% 1965 Dover (reprint), Table 25.9, p. 923

nn = fix(n);                %  Make sure number of nodes is an integer
x = zeros(nn,1);  w = x;    %  Preallocate x and w vectors

switch nn
  case 1
%      nodes                           weights
    x(1) =  1.000000000000000;     w(1) =    1.000000000000000e+00;

  case 2
%      nodes                           weights
    x(1) =  0.585786437626905;     w(1) =    8.535533905932735e-01;
    x(2) =  3.414213562373095;     w(2) =    1.464466094067262e-01;

  case 3
%      nodes                           weights
    x(1) =  0.415774556783479;     w(1) =    7.110930099291731e-01;
    x(2) =  2.294280360279041;     w(2) =    2.785177335692408e-01;
    x(3) =  6.289945082937479;     w(3) =    1.038925650158613e-02;

  case 4
%      nodes                           weights
    x(1) =  0.322547689619392;     w(1) =    6.031541043416339e-01;
    x(2) =  1.745761101158348;     w(2) =    3.574186924378002e-01;
    x(3) =  4.536620296921129;     w(3) =    3.888790851500540e-02;
    x(4) =  9.395070912301135;     w(4) =    5.392947055613275e-04;

  case 5
%      nodes                           weights
    x(1) =  0.263560319718141;     w(1) =    5.217556105828087e-01;
    x(2) =  1.413403059106517;     w(2) =    3.986668110831758e-01;
    x(3) =  3.596425771040723;     w(3) =    7.594244968170771e-02;
    x(4) =  7.085810005858831;     w(4) =    3.611758679922054e-03;
    x(5) = 12.640800844275784;     w(5) =    2.336997238577616e-05;

  case 6
%      nodes                           weights
    x(1) =  0.222846604179260;     w(1) =    4.589646739499636e-01;
    x(2) =  1.188932101672623;     w(2) =    4.170008307721207e-01;
    x(3) =  2.992736326059315;     w(3) =    1.133733820740450e-01;
    x(4) =  5.775143569104510;     w(4) =    1.039919745314910e-02;
    x(5) =  9.837467418382586;     w(5) =    2.610172028149328e-04;
    x(6) = 15.982873980601701;     w(6) =    8.985479064296189e-07;

  case 7
%      nodes                           weights
    x(1) =  0.193043676560362;     w(1) =    4.093189517012742e-01;
    x(2) =  1.026664895339192;     w(2) =    4.218312778617200e-01;
    x(3) =  2.567876744950745;     w(3) =    1.471263486575053e-01;
    x(4) =  4.900353084526483;     w(4) =    2.063351446871692e-02;
    x(5) =  8.182153444562857;     w(5) =    1.074010143280745e-03;
    x(6) = 12.734180291797818;     w(6) =    1.586546434856409e-05;
    x(7) = 19.395727862262543;     w(7) =    3.170315478995578e-08;

  case 8
%      nodes                           weights
    x(1) =  0.170279632305101;     w(1) =    3.691885893416376e-01;
    x(2) =  0.903701776799380;     w(2) =    4.187867808143428e-01;
    x(3) =  2.251086629866130;     w(3) =    1.757949866371717e-01;
    x(4) =  4.266700170287658;     w(4) =    3.334349226121565e-02;
    x(5) =  7.045905402393465;     w(5) =    2.794536235225675e-03;
    x(6) = 10.758516010180994;     w(6) =    9.076508773358203e-05;
    x(7) = 15.740678641278011;     w(7) =    8.485746716272529e-07;
    x(8) = 22.863131736889272;     w(8) =    1.048001174871506e-09;

  case 9
%      nodes                           weights
    x(1) =  0.152322227731809;     w(1) =    3.361264217979623e-01;
    x(2) =  0.807220022742256;     w(2) =    4.112139804239842e-01;
    x(3) =  2.005135155619348;     w(3) =    1.992875253708855e-01;
    x(4) =  3.783473973331234;     w(4) =    4.746056276565155e-02;
    x(5) =  6.204956777876616;     w(5) =    5.599626610794583e-03;
    x(6) =  9.372985251687579;     w(6) =    3.052497670932107e-04;
    x(7) = 13.466236911092109;     w(7) =    6.592123026075337e-06;
    x(8) = 18.833597788991714;     w(8) =    4.110769330349547e-08;
    x(9) = 26.374071890927379;     w(9) =    3.290874030350721e-11;

  case 10
%      nodes                           weights
    x(1) =  0.137793470540492;     w(1) =    3.084411157650207e-01;
    x(2) =  0.729454549503171;     w(2) =    4.011199291552737e-01;
    x(3) =  1.808342901740316;     w(3) =    2.180682876118094e-01;
    x(4) =  3.401433697854900;     w(4) =    6.208745609867763e-02;
    x(5) =  5.552496140063805;     w(5) =    9.501516975181109e-03;
    x(6) =  8.330152746764501;     w(6) =    7.530083885875356e-04;
    x(7) = 11.843785837900070;     w(7) =    2.825923349599557e-05;
    x(8) = 16.279257831378104;     w(8) =    4.249313984962717e-07;
    x(9) = 21.996585811980772;     w(9) =    1.839564823979625e-09;
    x(10) = 29.920697012273898;     w(10) =    9.911827219609029e-13;

  case 11
%      nodes                           weights
    x(1) =  0.125796442187968;     w(1) =    2.849332128942006e-01;
    x(2) =  0.665418255839228;     w(2) =    3.897208895278491e-01;
    x(3) =  1.647150545872169;     w(3) =    2.327818318489914e-01;
    x(4) =  3.091138143035254;     w(4) =    7.656445354619669e-02;
    x(5) =  5.029284401579831;     w(5) =    1.439328276735067e-02;
    x(6) =  7.509887863806610;     w(6) =    1.518880846484876e-03;
    x(7) = 10.605950999546968;     w(7) =    8.513122435471903e-05;
    x(8) = 14.431613758064179;     w(8) =    2.292403879574509e-06;
    x(9) = 19.178857403214653;     w(9) =    2.486353702767818e-08;
    x(10) = 25.217709339677569;     w(10) =    7.712626933691196e-11;
    x(11) = 33.497192847175533;     w(11) =    2.883775868323628e-14;

  case 12
%      nodes                           weights
    x(1) =  0.115722117358021;     w(1) =    2.647313710554435e-01;
    x(2) =  0.611757484515131;     w(2) =    3.777592758731382e-01;
    x(3) =  1.512610269776419;     w(3) =    2.440820113198774e-01;
    x(4) =  2.833751337743509;     w(4) =    9.044922221168074e-02;
    x(5) =  4.599227639418353;     w(5) =    2.010238115463406e-02;
    x(6) =  6.844525453115181;     w(6) =    2.663973541865321e-03;
    x(7) =  9.621316842456871;     w(7) =    2.032315926629993e-04;
    x(8) = 13.006054993306350;     w(8) =    8.365055856819753e-06;
    x(9) = 17.116855187462260;     w(9) =    1.668493876540914e-07;
    x(10) = 22.151090379396983;     w(10) =    1.342391030515027e-09;
    x(11) = 28.487967250983992;     w(11) =    3.061601635035012e-12;
    x(12) = 37.099121044466926;     w(12) =    8.148077467426124e-16;

  case 13
%      nodes                           weights
    x(1) =  0.107142388472252;     w(1) =    2.471887084299629e-01;
    x(2) =  0.566131899040402;     w(2) =    3.656888229005218e-01;
    x(3) =  1.398564336451020;     w(3) =    2.525624200576586e-01;
    x(4) =  2.616597108406412;     w(4) =    1.034707580241836e-01;
    x(5) =  4.238845929017034;     w(5) =    2.643275441556165e-02;
    x(6) =  6.292256271140078;     w(6) =    4.220396040254745e-03;
    x(7) =  8.815001941186980;     w(7) =    4.118817704727351e-04;
    x(8) = 11.861403588811243;     w(8) =    2.351547398155331e-05;
    x(9) = 15.510762037703755;     w(9) =    7.317311620249146e-07;
    x(10) = 19.884635663880221;     w(10) =    1.108841625703973e-08;
    x(11) = 25.185263864677768;     w(11) =    6.770826692205850e-11;
    x(12) = 31.800386301947270;     w(12) =    1.159979959905077e-13;
    x(13) = 40.723008669265582;     w(13) =    2.245093203892749e-17;

  case 14
%      nodes                           weights
    x(1) =  0.099747507032597;     w(1) =    2.318155771448655e-01;
    x(2) =  0.526857648851903;     w(2) =    3.537846915975430e-01;
    x(3) =  1.300629121251497;     w(3) =    2.587346102454282e-01;
    x(4) =  2.430801078730846;     w(4) =    1.154828935569231e-01;
    x(5) =  3.932102822293219;     w(5) =    3.319209215933736e-02;
    x(6) =  5.825536218301709;     w(6) =    6.192869437006579e-03;
    x(7) =  8.140240141565144;     w(7) =    7.398903778673880e-04;
    x(8) = 10.916499507366012;     w(8) =    5.490719466841721e-05;
    x(9) = 14.210805011161286;     w(9) =    2.409585764085366e-06;
    x(10) = 18.104892220218115;     w(10) =    5.801543981676485e-08;
    x(11) = 22.723381628269642;     w(11) =    6.819314692484891e-10;
    x(12) = 28.272981723248211;     w(12) =    3.221207751894853e-12;
    x(13) = 35.149443660592432;     w(13) =    4.221352440516609e-15;
    x(14) = 44.366081711117417;     w(14) =    6.052375022289181e-19;

  case 16
%      nodes                           weights
    x(1) =  0.087649410478928;     w(1) =    2.061517149578016e-01;
    x(2) =  0.462696328915081;     w(2) =    3.310578549508837e-01;
    x(3) =  1.141057774831228;     w(3) =    2.657957776442144e-01;
    x(4) =  2.129283645098383;     w(4) =    1.362969342963770e-01;
    x(5) =  3.437086633893207;     w(5) =    4.732892869412523e-02;
    x(6) =  5.078018614549770;     w(6) =    1.129990008033939e-02;
    x(7) =  7.070338535048236;     w(7) =    1.849070943526311e-03;
    x(8) =  9.438314336391938;     w(8) =    2.042719153082776e-04;
    x(9) = 12.214223368866158;     w(9) =    1.484458687398130e-05;
    x(10) = 15.441527368781626;     w(10) =    6.828319330871144e-07;
    x(11) = 19.180156856753154;     w(11) =    1.881024841079652e-08;
    x(12) = 23.515905693991925;     w(12) =    2.862350242973877e-10;
    x(13) = 28.578729742882135;     w(13) =    2.127079033224117e-12;
    x(14) = 34.583398702286665;     w(14) =    6.297967002517678e-15;
    x(15) = 41.940452647688311;     w(15) =    5.050473700035650e-18;
    x(16) = 51.701160339543343;     w(16) =    4.161462370372826e-22;

  case 17
%      nodes                           weights
    x(1) =  0.082638214708948;     w(1) =    1.953322052517708e-01;
    x(2) =  0.436150323558711;     w(2) =    3.203753572745405e-01;
    x(3) =  1.075176577511429;     w(3) =    2.673297263571708e-01;
    x(4) =  2.005193531649233;     w(4) =    1.451298543587585e-01;
    x(5) =  3.234256124047443;     w(5) =    5.443694324533853e-02;
    x(6) =  4.773513513700198;     w(6) =    1.435729776606183e-02;
    x(7) =  6.637829205364961;     w(7) =    2.662824735572763e-03;
    x(8) =  8.846685511169797;     w(8) =    3.436797271563025e-04;
    x(9) = 11.425529319373348;     w(9) =    3.027551783782896e-05;
    x(10) = 14.407823037481313;     w(10) =    1.768515053231681e-06;
    x(11) = 17.838284730701147;     w(11) =    6.576272886810442e-08;
    x(12) = 21.778268257722296;     w(12) =    1.469730932159536e-09;
    x(13) = 26.315317811248800;     w(13) =    1.816910362555468e-11;
    x(14) = 31.581771680456761;     w(14) =    1.095401388928672e-13;
    x(15) = 37.796093837477137;     w(15) =    2.617373882223325e-16;
    x(16) = 45.375716533988971;     w(16) =    1.672935693146154e-19;
    x(17) = 55.389751789839607;     w(17) =    1.065626316274051e-23;

  case 18
%      nodes                           weights
    x(1) =  0.078169166669706;     w(1) =    1.855886031469193e-01;
    x(2) =  0.412490085259130;     w(2) =    3.101817663702247e-01;
    x(3) =  1.016520179623539;     w(3) =    2.678665671485359e-01;
    x(4) =  1.894888509969760;     w(4) =    1.529797474680750e-01;
    x(5) =  3.054353113202662;     w(5) =    6.143491786096171e-02;
    x(6) =  4.504205538889891;     w(6) =    1.768721308077299e-02;
    x(7) =  6.256725073949110;     w(7) =    3.660179767759904e-03;
    x(8) =  8.327825156605627;     w(8) =    5.406227870077342e-04;
    x(9) = 10.737990047757604;     w(9) =    5.616965051214256e-05;
    x(10) = 13.513656207555096;     w(10) =    4.015307883701155e-06;
    x(11) = 16.689306281930094;     w(11) =    1.914669856675682e-07;
    x(12) = 20.310767626267747;     w(12) =    5.836095268631618e-09;
    x(13) = 24.440681359283698;     w(13) =    1.071711266955400e-10;
    x(14) = 29.168208662579627;     w(14) =    1.089098713888835e-12;
    x(15) = 34.627927065660188;     w(15) =    5.386664748378341e-15;
    x(16) = 41.041816772808737;     w(16) =    1.049865978035703e-17;
    x(17) = 48.833922716086562;     w(17) =    5.405398451630974e-21;
    x(18) = 59.090546435901260;     w(18) =    2.691653269201047e-25;

  case 19
%      nodes                           weights
    x(1) =  0.074158783757206;     w(1) =    1.767684749159133e-01;
    x(2) =  0.391268613319995;     w(2) =    3.004781436072535e-01;
    x(3) =  0.963957343997959;     w(3) =    2.675995470381755e-01;
    x(4) =  1.796175582068327;     w(4) =    1.599133721355806e-01;
    x(5) =  2.893651381873784;     w(5) =    6.824937997614915e-02;
    x(6) =  4.264215539627767;     w(6) =    2.123930760654438e-02;
    x(7) =  5.918141561644051;     w(7) =    4.841627351148375e-03;
    x(8) =  7.868618915334737;     w(8) =    8.049127473813633e-04;
    x(9) = 10.132423716815268;     w(9) =    9.652472093153448e-05;
    x(10) = 12.730881463842405;     w(10) =    8.207305258050987e-06;
    x(11) = 15.691278339835906;     w(11) =    4.830566724730710e-07;
    x(12) = 19.048993209823550;     w(12) =    1.904991361123320e-08;
    x(13) = 22.850849760829462;     w(13) =    4.816684630928128e-10;
    x(14) = 27.160669327411444;     w(14) =    7.348258839551074e-12;
    x(15) = 32.069122251862268;     w(15) =    6.202275387572570e-14;
    x(16) = 37.712905801219598;     w(16) =    2.541430843015534e-16;
    x(17) = 44.317362795831521;     w(17) =    4.078861296825621e-19;
    x(18) = 52.312902457404377;     w(18) =    1.707750187593848e-22;
    x(19) = 62.802423153500371;     w(19) =    6.715064649908208e-27;

  case 20
%      nodes                           weights
    x(1) =  0.070539889691989;     w(1) =    1.687468018511149e-01;
    x(2) =  0.372126818001612;     w(2) =    2.912543620060674e-01;
    x(3) =  0.916582102483273;     w(3) =    2.666861028670004e-01;
    x(4) =  1.707306531028342;     w(4) =    1.660024532695066e-01;
    x(5) =  2.749199255309430;     w(5) =    7.482606466879230e-02;
    x(6) =  4.048925313850887;     w(6) =    2.496441730928328e-02;
    x(7) =  5.615174970861620;     w(7) =    6.202550844572215e-03;
    x(8) =  7.459017453671069;     w(8) =    1.144962386476901e-03;
    x(9) =  9.594392869581101;     w(9) =    1.557417730278111e-04;
    x(10) = 12.038802546964321;     w(10) =    1.540144086522490e-05;
    x(11) = 14.814293442630746;     w(11) =    1.086486366517978e-06;
    x(12) = 17.948895520519379;     w(12) =    5.330120909556746e-08;
    x(13) = 21.478788240285017;     w(13) =    1.757981179050583e-09;
    x(14) = 25.451702793186890;     w(14) =    3.725502402512387e-11;
    x(15) = 29.932554631700611;     w(15) =    4.767529251578165e-13;
    x(16) = 35.013434240479008;     w(16) =    3.372844243362378e-15;
    x(17) = 40.833057056728528;     w(17) =    1.155014339500410e-17;
    x(18) = 47.619994047346424;     w(18) =    1.539522140582393e-20;
    x(19) = 55.810795750063882;     w(19) =    5.286442725569194e-24;
    x(20) = 66.524416525615734;     w(20) =    1.656456612499026e-28;

  case 21
%      nodes                           weights
    x(1) =  0.067257817923162;     w(1) =    1.614201001816388e-01;
    x(2) =  0.354772895323512;     w(2) =    2.824935645829945e-01;
    x(3) =  0.873660166778642;     w(3) =    2.652545755139000e-01;
    x(4) =  1.626869941929211;     w(4) =    1.713193963900214e-01;
    x(5) =  2.618626410545548;     w(5) =    8.112662589235328e-02;
    x(6) =  3.854652138109764;     w(6) =    2.881630176776937e-02;
    x(7) =  5.342369280622438;     w(7) =    7.734239426118691e-03;
    x(8) =  7.091168813219679;     w(8) =    1.567481390421184e-03;
    x(9) =  9.112778854269704;     w(9) =    2.384226587634135e-04;
    x(10) = 11.421771762378389;     w(10) =    2.693007343968608e-05;
    x(11) = 14.036270697873757;     w(11) =    2.224790793645034e-06;
    x(12) = 16.978952692783839;     w(12) =    1.317334497432325e-07;
    x(13) = 20.278509414993742;     w(13) =    5.443952290646403e-09;
    x(14) = 23.971845587151481;     w(14) =    1.516366205198049e-10;
    x(15) = 28.107528600944310;     w(15) =    2.717883118058924e-12;
    x(16) = 32.751497410560859;     w(16) =    2.942519354071892e-14;
    x(17) = 37.997187819260901;     w(17) =    1.759074035797758e-16;
    x(18) = 43.985245757142245;     w(18) =    5.073802227171857e-19;
    x(19) = 50.947351189940001;     w(19) =    5.659720870324156e-22;
    x(20) = 59.325994120230057;     w(20) =    1.606260924799303e-25;
    x(21) = 70.255688628018987;     w(21) =    4.044133927115962e-30;

  case 22
%      nodes                           weights
    x(1) =  0.064267628744808;     w(1) =    1.547019876398929e-01;
    x(2) =  0.338967254814911;     w(2) =    2.741750823285652e-01;
    x(3) =  0.834589985449178;     w(3) =    2.634097015356333e-01;
    x(4) =  1.553713386750029;     w(4) =    1.759346092630729e-01;
    x(5) =  2.500006236736174;     w(5) =    8.712562217220969e-02;
    x(6) =  3.678420344463639;     w(6) =    3.275268789653855e-02;
    x(7) =  5.095349068968740;     w(7) =    9.424900256998254e-03;
    x(8) =  6.758835515813549;     w(8) =    2.077335752654618e-03;
    x(9) =  8.678853313678429;     w(9) =    3.491673714923024e-04;
    x(10) = 10.867686893540569;     w(10) =    4.438219314066132e-05;
    x(11) = 13.340451051495238;     w(11) =    4.214229901104629e-06;
    x(12) = 16.115811338766310;     w(12) =    2.940668246130181e-07;
    x(13) = 19.217003684901339;     w(13) =    1.476193826389766e-08;
    x(14) = 22.673316601434554;     w(14) =    5.186423025724953e-10;
    x(15) = 26.522319587637117;     w(15) =    1.230526251554398e-11;
    x(16) = 30.813357944506542;     w(16) =    1.880465509631468e-13;
    x(17) = 35.613335203196172;     w(17) =    1.735564139126855e-15;
    x(18) = 41.016968598471671;     w(18) =    8.831402308327170e-18;
    x(19) = 47.166757849153512;     w(19) =    2.160718646818207e-20;
    x(20) = 54.297385256578849;     w(20) =    2.031119967583335e-23;
    x(21) = 62.857096246298937;     w(21) =    4.797903520990897e-27;
    x(22) = 73.995507008599532;     w(22) =    9.780246506683544e-32;

  case 23
%      nodes                           weights
    x(1) =  0.061532037757520;     w(1) =    1.485197990820467e-01;
    x(2) =  0.324511329154553;     w(2) =    2.662763422220287e-01;
    x(3) =  0.798873968692984;     w(3) =    2.612370674653506e-01;
    x(4) =  1.486886334222197;     w(4) =    1.799149140382857e-01;
    x(5) =  2.391755829792768;     w(5) =    9.280788216398930e-02;
    x(6) =  3.517797442503534;     w(6) =    3.673579259475957e-02;
    x(7) =  4.870560368733451;     w(7) =    1.126058922254349e-02;
    x(8) =  6.456991306767736;     w(8) =    2.677540143126999e-03;
    x(9) =  8.285651892598002;     w(9) =    4.923896728665586e-04;
    x(10) = 10.367009043445769;     w(10) =    6.956649894243928e-05;
    x(11) = 12.713825028162598;     w(11) =    7.476361523134085e-06;
    x(12) = 15.341687572888507;     w(12) =    6.030632412462966e-07;
    x(13) = 18.269742393895992;     w(13) =    3.588339690021515e-08;
    x(14) = 21.521727850814141;     w(14) =    1.540551240061165e-09;
    x(15) = 25.127477130115508;     w(15) =    4.639077530348996e-11;
    x(16) = 29.125175108751012;     w(16) =    9.446912374131420e-13;
    x(17) = 33.564896563116399;     w(17) =    1.239741169314352e-14;
    x(18) = 38.514459677180717;     w(18) =    9.821168268011364e-17;
    x(19) = 44.069807814871254;     w(19) =    4.281846844983449e-19;
    x(20) = 50.375226603043814;     w(20) =    8.943238836296874e-22;
    x(21) = 57.668304350434092;     w(21) =    7.129396795317911e-25;
    x(22) = 66.402873068345201;     w(22) =    1.410767108895284e-28;
    x(23) = 77.743227284712361;     w(23) =    2.344614766311685e-33;

  case 24
%      nodes                           weights
    x(1) =  0.059019852181508;     w(1) =    1.428119733347820e-01;
    x(2) =  0.311239146198483;     w(2) =    2.587741075174232e-01;
    x(3) =  0.766096905545936;     w(3) =    2.588067072728699e-01;
    x(4) =  1.425597590803613;     w(4) =    1.833226889777778e-01;
    x(5) =  2.292562058632190;     w(5) =    9.816627262991875e-02;
    x(6) =  3.370774264208996;     w(6) =    4.073247815140859e-02;
    x(7) =  4.665083703467167;     w(7) =    1.322601940512009e-02;
    x(8) =  6.181535118736766;     w(8) =    3.369349058478263e-03;
    x(9) =  7.927539247172152;     w(9) =    6.721625640935491e-04;
    x(10) =  9.912098015077705;     w(10) =    1.044612146592746e-04;
    x(11) = 12.146102711729773;     w(11) =    1.254472197799318e-05;
    x(12) = 14.642732289596678;     w(12) =    1.151315812737269e-06;
    x(13) = 17.417992646508981;     w(13) =    7.960812959133550e-08;
    x(14) = 20.491460082616438;     w(14) =    4.072858987549957e-09;
    x(15) = 23.887329848169752;     w(15) =    1.507008226292567e-10;
    x(16) = 27.635937174332742;     w(16) =    3.917736515058387e-12;
    x(17) = 31.776041352374715;     w(17) =    6.894181052958219e-14;
    x(18) = 36.358405801651614;     w(18) =    7.819800382459429e-16;
    x(19) = 41.451720484870776;     w(19) =    5.350188813009955e-18;
    x(20) = 47.153106445156318;     w(20) =    2.010517464555523e-20;
    x(21) = 53.608574544695017;     w(21) =    3.605765864553080e-23;
    x(22) = 61.058531447218769;     w(22) =    2.451818845878402e-26;
    x(23) = 69.962240035105083;     w(23) =    4.088301593680406e-30;
    x(24) = 81.498279233948836;     w(24) =    5.575345788328487e-35;

  case 15
%      nodes                           weights
    x(1) =  0.093307812017282;     w(1) =    2.182348859400872e-01;
    x(2) =  0.492691740301884;     w(2) =    3.422101779228834e-01;
    x(3) =  1.215595412070949;     w(3) =    2.630275779416803e-01;
    x(4) =  2.269949526203743;     w(4) =    1.264258181059306e-01;
    x(5) =  3.667622721751437;     w(5) =    4.020686492100094e-02;
    x(6) =  5.425336627413556;     w(6) =    8.563877803611813e-03;
    x(7) =  7.565916226613068;     w(7) =    1.212436147214254e-03;
    x(8) = 10.120228568019114;     w(8) =    1.116743923442522e-04;
    x(9) = 13.130282482175724;     w(9) =    6.459926762022885e-06;
    x(10) = 16.654407708329966;     w(10) =    2.226316907096266e-07;
    x(11) = 20.776478899448776;     w(11) =    4.227430384979381e-09;
    x(12) = 25.623894226728787;     w(12) =    3.921897267041136e-11;
    x(13) = 31.407519169753943;     w(13) =    1.456515264073122e-13;
    x(14) = 38.530683306485990;     w(14) =    1.483027051113311e-16;
    x(15) = 48.026085572685794;     w(15) =    1.600594906211129e-20;

  case 25
%      nodes                           weights
    x(1) =  0.056704775452706;     w(1) =    1.375260142293455e-01;
    x(2) =  0.299010898586989;     w(2) =    2.516452737649086e-01;
    x(3) =  0.735909555435016;     w(3) =    2.561760028097560e-01;
    x(4) =  1.369183116035193;     w(4) =    1.862154903624361e-01;
    x(5) =  2.201326053721465;     w(5) =    1.031998481075207e-01;
    x(6) =  3.235675803558034;     w(6) =    4.471416112993361e-02;
    x(7) =  4.476496615073830;     w(7) =    1.530523288639544e-02;
    x(8) =  5.929083762700445;     w(8) =    4.152414632877108e-03;
    x(9) =  7.599899309956746;     w(9) =    8.920990732596834e-04;
    x(10) =  9.496749220932433;     w(10) =    1.511560191642415e-04;
    x(11) = 11.629014911778741;     w(11) =    2.006553180193321e-05;
    x(12) = 14.007957976545065;     w(12) =    2.067774396431873e-06;
    x(13) = 16.647125597288777;     w(13) =    1.634652022291161e-07;
    x(14) = 19.562898011469052;     w(14) =    9.766015062124498e-09;
    x(15) = 22.775241986835038;     w(15) =    4.327720794184913e-10;
    x(16) = 26.308772390968887;     w(16) =    1.389600963389507e-11;
    x(17) = 30.194291163316109;     w(17) =    3.138922792539912e-13;
    x(18) = 34.471097571922037;     w(18) =    4.802614822604315e-15;
    x(19) = 39.190608803937415;     w(19) =    4.735885364807389e-17;
    x(20) = 44.422349336161965;     w(20) =    2.814205379843154e-19;
    x(21) = 50.264574993833534;     w(21) =    9.164954395991217e-22;
    x(22) = 56.864967173940222;     w(22) =    1.418940009497175e-24;
    x(23) = 64.466670615954172;     w(23) =    8.273651944099073e-28;
    x(24) = 73.534234792100108;     w(24) =    1.168881711542845e-31;
    x(25) = 85.260155562495967;     w(25) =    1.315831500059124e-36;

  otherwise
    error(sprintf('Gauss-Laguerre quadrature with %d nodes not supported',nn));

end
